/****************************************************************************/
/**                                                                        **/
/**                         HSI API Sample Program                         **/
/**                                                                        **/
/**                   Aladdin Knowledge Systems, Germany                   **/
/**                                                                        **/
/**  Revision history                                                      **/
/**  ----------------
***  $Log: hsidemo.c $
***  Revision 1.1  1998/07/29 08:16:27  Henri
***  Initial revision
***
**/
/****************************************************************************/
#include <stdio.h>
#include <string.h>
#include <windows.h>
#include "hsiapi.h"

void DisplayResult (HSIRET);

BOOL Info    = FALSE;
BOOL Install = FALSE;
BOOL Remove  = FALSE;
BOOL Start   = FALSE;
BOOL Stop    = FALSE;

HSIRET main(int argc, char *argv[])
{
HSIRET ret;
HSIRET OSVersion;
WORD   i;
WORD   version;

printf( "Aladdin Win32 HL-Server Installation API sample program.\n");
printf( "Aladdin Knowledge Systems Ltd. (c) 1998.\n");

/* ---------------------- */
/* Check the parameters : */
/* ---------------------- */
if (argc < 2)
  {
  printf( "\n    Usage: %s <parameter>\n", strupr(argv[0]));
  printf( "\n    -info         Get status informations about HL-Server.");
  printf( "\n    -install      Install HL-Server.");
  printf( "\n    -start        Start HL-Server.");
  printf( "\n    -stop         Stop HL-Server service.");
  printf( "\n    -remove       Remove HL-Server.\n\n");
  return (0);
  }
for (i = 0; i < argc; i++)
  {
  if ((stricmp(argv[i], "-info") == 0) || (stricmp(argv[i], "/info") == 0))
    Info = TRUE;
  if ((stricmp(argv[i], "-install") == 0) || (stricmp(argv[i], "/install") == 0))
    Install = TRUE;
  if ((stricmp(argv[i], "-remove") == 0) || (stricmp(argv[i], "/remove") == 0))
    Remove = TRUE;
  if ((stricmp(argv[i], "-start") == 0) || (stricmp(argv[i], "/start") == 0))
    Start = TRUE;
  if ((stricmp(argv[i], "-stop") == 0) || (stricmp(argv[i], "/stop") == 0))
    Stop = TRUE;
  }

/* ---------------------- */
/* Get operating system : */
/* ---------------------- */
OSVersion = HSIGetOSVersion();
switch (OSVersion)
  {
  case WIN_NT:
    printf("\n* Running on Windows NT.");
    break;
  case WIN_9x:
    printf("\n* Running on Windows 9x.");
    break;
  case WIN_32s:
    printf("\n* Running on Win32s.");
    break;
  }

/* ------------------------------------------ */
/* Get status informations about the server : */
/* ------------------------------------------ */
if (Info == TRUE)
  {
  printf("\n* Retrieve status informations about HL-Server...");
  ret = HSIGetStatus();
  DisplayResult(ret);
  if (OSVersion == WIN_NT)
    {
    if ((ret == HSI_SERVER_NOT_RUNNING) || (ret == HSI_SERVER_RUNNING))
      {
      version = HSIGetVersion(NULL);
      printf("\n* HL-Server Version is: %2d.%02d", version >> 8, version & 255);
      }
    }
  else
    {
    if (ret == HSI_SERVER_RUNNING)
      {
      version = HSIGetVersion(NULL);
      printf("\n* HL-Server Version is: %2d.%02d", version >> 8, version & 255);
      }
    }
  }

/* -------------------- */
/* Install the server : */
/* -------------------- */
if (Install == TRUE)
  {
  printf("\n* Installing HL-Server...");
  ret = HSIInstallServer(0, NULL, NULL);
  DisplayResult(ret);
  }

/* ------------------ */
/* Start the server : */
/* ------------------ */
if (Start == TRUE)
  {
  printf("\n* Starting HL-Server...");
  ret = HSIStartServer(NULL);
  DisplayResult(ret);
  }

/* ----------------- */
/* Stop the server : */
/* ----------------- */
if (Stop == TRUE)
  {
  printf("\n* Stopping HL-Server...");
  ret = HSIStopServer();
  DisplayResult(ret);
  }

/* ------------------- */
/* Remove the server : */
/* ------------------- */
if (Remove == TRUE)
  {
  printf("\n* Removing HL-Server...");
  ret = HSIRemoveServer(0);
  DisplayResult(ret);
  }

printf("\n* Done.\n");
return (ret);
}

/******************************************************************************/
void DisplayResult (HSIRET rc)
/******************************************************************************/
{
char ErrorText[256];

switch (rc)
    {
    case HSI_SUCCESS:
        printf("\n* OK.");
        break;
    case HSI_FAIL:
        printf("\n* Failed.");
        break;
    case HSI_SERVER_NOT_INSTALLED:
        printf("\n* Server is not installed.");
        break;
    case HSI_SERVER_NOT_RUNNING:
        printf("\n* Server is not running.");
        break;
    case HSI_SERVER_RUNNING:
        printf("\n* Server running.");
        break;
    case HSI_OPENSERVICE_FAILED:
        printf("\n* Failed to open Service.");
        break;
    case HSI_OPENSCMANAGER_FAILED:
        printf("\n* Failed to open Service Manager.");
        break;
    case HSI_CREATESERVICE_FAILED:
        printf("\n* Failed to create service.");
        break;
    case HSI_FILECOPY_FAILED:
        printf("\n* Failed to copy server binary.");
        break;
    case HSI_OS_NOT_SUPPORTED:
        printf("\n* Function not supported under this operating system.");
        break;
    default:
        printf("\n* Unknown error!");
        printf("\n* %s", HSIGetLastErrorText(ErrorText, 256));
        break;
    }
}

